function [numbers]=get_numbers_from_string(parentstring,strings)
% Find numbers inside the string "parentstring"
% For each element of "strings" the corresponding element of "numbers"
% is the number immedeately following "strings{i}" in "parentstring"

            numbers=zeros(numel(strings),1);
            for i=1:numel(strings) 
                
                k = strfind(parentstring,strings{i})+length(strings{i});
                if numel(k)==1
                    aaa=sscanf(parentstring(k:end), '%g', 1);
                    if isempty(aaa)
                    	fprintf('\nThe Characters following "')
                        fprintf(strings{i})
                        fprintf('" are not a number.\nDefining answer to be NaN.\n')
                        numbers(i)=NaN;
                    else
                        numbers(i)=aaa;
                    end
                elseif numel(k)>1
                    fprintf('\nMore than one instance of "')
                    fprintf(strings{i})
                    fprintf('" found.\nUsing first\n')
                    aaa=sscanf(parentstring(k(1):end), '%g', 1);
                    if isempty(aaa)
                    	fprintf('\nThe characters following "')
                        fprintf(strings{i})
                        fprintf('" are not a number.\nDefining answer to be NaN.\n')
                        numbers(i)=NaN;
                    else
                        numbers(i)=aaa;
                    end
                else
                    fprintf('\n"')
                    fprintf(strings{i})
                    fprintf('" not found.\nDefining answer to be NaN.\n')
                    numbers(i)=NaN;
                end
            end
end
            